PROGRAM square_and_cube_roots
!
!  Purpose:
!    To calculate a table of numbers, square roots, and cube roots
!    using an implied DO loop to output the table.
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    08/22/95    S. J. Chapman        Original code
!
IMPLICIT NONE

! List of parameters:
INTEGER, PARAMETER :: max_size = 10

! List of variables:
INTEGER :: j                             ! Loop index
REAL, DIMENSION(max_size) :: value       ! Array of numbers
REAL, DIMENSION(max_size) :: square_root ! Array of square roots
REAL, DIMENSION(max_size) :: cube_root   ! Array of cube roots

! Calculate the square roots & cube roots of the numbers.
DO j = 1, max_size
   value(j) = real(j)
   square_root(j) = sqrt(value(j))
   cube_root(j) = value(j)**(1./3.)
END DO
 
! Write out each number, its square root, and its cube root.
WRITE (*,100) 
100 FORMAT ('0',20X,'Table of Square and Cube Roots',/, &
             4X,'  Number    Square Root  Cube Root', &
             3X,'  Number    Square Root  Cube Root',/, &
             4X,'  ======    ===========  =========', &
             3X,'  ======    ===========  =========')
WRITE (*,110) (value(j), square_root(j), cube_root(j), j = 1, max_size)
110 FORMAT (2(4X,F6.0,9X,F6.4,6X,F6.4))
 
END PROGRAM

